////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <MSSOrchestration/ActivationDelegate.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link OnlineActivationDelegate} interface defines the methods that must be implemented
 * in order to receive delegates during the online activation process.
 */
NS_REFINED_FOR_SWIFT
@protocol OnlineActivationDelegate <ActivationDelegate>

/**
 * Called upon activation step success, the provided command must be sent to the server.
 *
 * @param command the command to be sent to the server
 */
- (void)onActivationStepCompleteWithCommand:(NSString *)command;

@end

NS_ASSUME_NONNULL_END
